package com.hero;

import java.io.File;

public class Launcher {

	public static void main(String[] args) {
		AppPrefs prefs = new AppPrefs();
		prefs.restorePrefs();
		String path = System.getProperty("java.home")+File.separator+"bin"+File.separator;
		String jarPath = System.getProperty("user.dir");
		boolean unix = System.getProperty("os.name").toUpperCase().indexOf(
				"WINDOWS") < 0;
		boolean macOSX = System.getProperty("os.name").toUpperCase().indexOf(
				"MAC") >= 0;
		String cmd = "javaw.exe -Xmx"
				+ prefs.getMaximumHeapSize() + "m -Xms"
				+ prefs.getMinimumHeapSize() + "m -cp \"" + jarPath
				+ File.separator + "HD6.jar\" com.hero.HeroDesigner ";
		if (unix) {
			cmd = path + "java -Xmx" + prefs.getMaximumHeapSize() + "m -Xms"
					+ prefs.getMinimumHeapSize() + "m -cp \"" + jarPath
					+ File.separator + "HD6.jar\" com.hero.HeroDesigner &";
		}
		for (String arg : args) {
			cmd += arg + " ";
		}
		// System.out.println(cmd);
		if (unix) { //launching Java from within Java doesn't work so well...
			HeroDesigner.main(args);
		} else {
			try {
				Runtime.getRuntime().exec(cmd);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
}
